package easik.sketch.util.Export;

import java.util.HashMap;

import easik.EasikConstants;


/**
 * A class containing constants required for SQL, and any String constants needed to access 
 * specific databases.
 * 
 * @author Vera Ranieri 2006
 * @since 2006-05-16 Vera Ranieri
 * @version 2006-06-29 Vera Ranieri
 *
 */
public final class ExportConstants extends EasikConstants{
	
	/**
	 * The string DB2
	 */
	public final static String DB2 = "DB2";
	/**
	 * The string MySQL
	 */
	public final static String MY_SQL = "MySQL";
	/**
	 * The string Oracle
	 */
	public final static String ORACLE = "Oracle";
	/**
	 * The string XML
	 */
	public final static String XML = "XML";
	/**
	 * The string UserDefined
	 */
	public final static String USER_DEFINED = "UserDefined";
	/**
	 * The string SQL
	 */
	public final static String SQL = "SQL";
	
	/**
	 * The host location for MySQL
	 */
	public final static String MySQL_HOST = "jdbc:mysql:";
	/**
	 * The driver location for MySQL
	 */
	public final static String MySQL_DRIVER_LOCATION = "com.mysql.jdbc.Driver";
	
	/**
	 * The host location for Oracle
	 */
	public final static String ORACLE_HOST = "jdbc:oracle:oci:@";
	/**
	 * The driver location for Oracle
	 */
	public final static String ORACLE_DRIVER_LOCATION = "oracle.jdbc";
	
	/**
	 * The host location for DB2
	 */
	public final static String DB2_HOST = "jdbc:db2:";
	/**
	 * The driver location for DB2
	 */
	public final static String DB2_DRIVER_LOCATION = "";
	
	/**
	 * Hash Map of driver locations, indexed by the type of database
	 */
	public final static HashMap DRIVER_LOCATIONS = new HashMap<String, String>(setDriverHashMap());
								 
	/**
	 * The platform locations, indexed by the type of database
	 */
	public final static HashMap SQL_PLATFORM_LOCATIONS = new HashMap<String, String>(setLocationHashMap());
	
	/**
	 * The <b>CREATE DATABASE</it> statement
	 */
	public final static String CREATE_DB = "CREATE DATABASE ";
	
	/**
	 * The <b>USE</b> statement
	 */
	public final static String USE = "USE ";
	
	/**
	 * The MySQL engine needed for foreign key enforcement
	 */
	public final static String MySQL_ENGINE = " ENGINE=INNODB;";
	
	/**
	 * The <b>CREATE TABLE</b> statement
	 */
	public final static String CREATE_TABLE = "CREATE TABLE ";
	
	/**
	 * The <b>PRIMARY KEY</b> statement
	 */
	public final static String PRIMARY = "PRIMARY KEY (";
	/**
	 * The <b>FOREIGN KEY</b> statement
	 */
	public final static String FOREIGN = "FOREIGN KEY (";
	/**
	 * The <b>REFERENCES</b> statement
	 */
	public final static String REF = "REFERENCES ";
	/**
	 * The <b>ON UPDATE CASCADE</b> statement
	 */
	public final static String ON_UPDATE = "ON UPDATE CASCADE ";
	/**
	 * The <b>ON DELETE CASCADE</b> statement
	 */
	public final static String ON_DELETE = "ON DELETE CASCADE ";
	/**
	 * The <b>UNIQUE</b> statement
	 */
	public final static String UNIQUE = "UNIQUE (";

	/**
	 * The extension used to define the unique primary key for each table
	 */
	public final static String ID = "_id ";
	/**
	 * The <b>NOT NULL</b> statement
	 */
	public final static String NOT_NULL = "NOT NULL ";
	/**
	 * The <b>AUTO_INCREMENT</b> statement
	 */
	public final static String AUTO_INCREMENT = "AUTO_INCREMENT ";
	/**
	 * The data type of the unique key
	 */
	public final static String ID_TYPE = "INTEGER ";
	
	/**
	 * The SQL file extension
	 */
	public final static String SQL_EXTENSION = ".sql";
	
	/**
	 * The statement to change the delimiter to the original delimiter
	 */
	public final static String DELIMITER = "DELIMITER ; \n";
	/**
	 * The statement to change the delimiter to a different delimiter, so processes can be defined
	 */
	public final static String DELIMITER$ = "DELIMITER $$ \n";
	
	/**
	 * The <b>CREATE PROCEDURE</b> statement
	 */
	public final static String CREATE_PROC = "CREATE PROCEDURE ";
	/**
	 * The parameters passed to a procedure
	 */
	public final static String PROC_PARAM = "(id INT) \n";
	
	/**
	 * The <b>BEGIN</b> statement
	 */
	public final static String BEGIN = "BEGIN \n";
	/**
	 * The <b>END</b> statement
	 */
	public final static String END = "END; \n";
	
	/**
	 * The statement creating the <it>Fail</it> table.  This table serves to record any failures caused by 
	 * invalid activity where defined by a procedure
	 */
	public final static String FAIL_TABLE = "CREATE TABLE Fail(" +
											"ErrorGID int(10) unsigned NOT NULL auto_increment, "  +
											"Message VARCHAR(128) DEFAULT NULL, " +
											"Created TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP, "+
											"PRIMARY KEY (ErrorGID), " +
											"UNIQUE KEY MessageIndex (Message)) "+
											"ENGINE=MEMORY "+
											"DEFAULT CHARSET=latin1 " +
											"ROW_FORMAT=FIXED \n";
	/**
	 * The procedure to enter an item into the fail table
	 */
	public final static String FAIL_PROC = "CREATE PROCEDURE fail(_Message VARCHAR(128)) "+
											"BEGIN "+
											"INSERT INTO Fail (Message) VALUES (_Message); " +
											"INSERT INTO Fail (Message) VALUES (_Message); " +
											"END; \n";
	/**
	 * Sets the driver hash map
	 * @return The set driver hash map
	 */
	private static HashMap<String, String> setDriverHashMap(){
		HashMap<String, String> map = new HashMap<String, String>();
		map.put(MY_SQL, MySQL_DRIVER_LOCATION);
		map.put(ORACLE, ORACLE_DRIVER_LOCATION);
		map.put(DB2, DB2_DRIVER_LOCATION);
		return map;
	}
	
	/**
	 * Sets the driver location hash map
	 * @return The driver location hash map
	 */
	private static HashMap<String, String> setLocationHashMap(){
		HashMap<String, String> map = new HashMap<String, String>();
		map.put(MY_SQL,MySQL_HOST );
		map.put(ORACLE,ORACLE_HOST);
		map.put(DB2, DB2_HOST);
		return map;
	}
}
